<?php
/**
 * @file MyGuestbookPlus.php
 * @package MyGuestbookPlus
 * @update 23.01.2012
 * @originalauthor Stefan Benicke
 * @author Rico Koch
 * @copyright Stefan Benicke <http://www.opusonline.at>
 * @copyright Rico Koch <http://nixag.com/>
 * @license GNU GPL v3 <http://www.gnu.org/licenses/gpl-3.0.html>
 * @version 1.4.0.2
 */
defined('is_running') or die('Not an entry point...');

class MyGuestbookPlus
{
	var $version = '1.4.0.2';
	var $config = array();
	var $configFile;
	
	function MyGuestbookPlus()
	{
/***///	echo '<script type="text/javascript">alert("function MyGuestbookPlus läuft");</script>';
		$this->init();

		$cmd = common::GetCommand();

		if (common::LoggedIn()) {
			switch($cmd) {
				case 'edit':
					$this->adminEditEntry();
					break;
				case 'admin_save':
					if ($this->adminSaveEntry()) $this->adminShowEntries();
					else $this->adminEditEntry();
					break;
				case 'delete':
					$this->adminDeleteEntry();
					$this->adminShowEntries();
					break;
				case 'config':
					$this->adminConfig();
					break;
				case 'save_config':
					$this->adminSaveConfig();
					$this->adminConfig();
					break;
				case 'chstate':
					$this->adminChangeState();
					$this->adminShowEntries();
					break;
				case 'about':
					$this->about();
					break;
				default:
					$this->adminShowEntries();
					break;
			}
		}
		else {
			switch($cmd) {
				case 'sign':
					$this->formSign();
					break;
				case 'save':
					if (!$this->saveNewEntry()) $this->formSign();
					else $this->showEntries();
					break;
				case 'preview':
					echo $this->parseBBCode($_POST['text']);
					die();
				case 'help':
					$this->help();
					break;
				default:
					$this->showEntries();
					break;
			}
		}
	}

	function init()
	{
/***///	echo '<script type="text/javascript">alert("function init läuft");</script>';
		global $langmessage, $addonPathData, $page, $addonFolderName, $addonRelativeCode;

		$this->configFile = $addonPathData.'/index.php';

		// GB plus fields
		$this->mygbp_infoFile = $addonPathData.'/index_mygbplus.php';
		$this->txtToPngTMPAbsolute = '';

		$this->getData();

		$page->head .= '<link rel="stylesheet" href="'.$addonRelativeCode.'/style.css" />';
		$page->admin_links[$langmessage['admin']] = common::GetUrl('Special_MyGuestbookPlus');
		$page->admin_links[$langmessage['configuration']] = common::GetUrl('Special_MyGuestbookPlus','cmd=config');
		$page->admin_links[] = array('Admin_Theme_Content',$langmessage['editable_text'],'cmd=addontext&addon='.urlencode($addonFolderName),' name="ajax_box" ');
		$page->admin_links[$langmessage['about']] = common::GetUrl('Special_MyGuestbookPlus','cmd=about');
	}

  function setMyGuestbookPlusVars() {
/***///	echo '<script type="text/javascript">alert("function setMyGuestbookPlusVars läuft");</script>';
  	// GB fields vars -- start
  	if(!isset($this->mygbp_info['show_email']) or $this->mygbp_info['show_email'] == '1') $this->mygbp_show_email = true;
      else $this->mygbp_show_email = false;
  	if(!isset($this->mygbp_info['show_url']) or $this->mygbp_info['show_url'] == '1') $this->mygbp_show_url = true;
      else $this->mygbp_show_url = false;
  	if(!isset($this->mygbp_info['show_country']) or $this->mygbp_info['show_country'] == '1') $this->mygbp_show_country = true;
      else $this->mygbp_show_country = false;
  	if(!isset($this->mygbp_info['show_location']) or $this->mygbp_info['show_location'] == '1') $this->mygbp_show_location = true;
      else $this->mygbp_show_location = false;
  	if(!isset($this->mygbp_info['show_icq']) or $this->mygbp_info['show_icq'] == '1') $this->mygbp_show_icq = true;
      else $this->mygbp_show_icq = false;
  	if(!isset($this->mygbp_info['show_skype']) or $this->mygbp_info['show_skype'] == '1') $this->mygbp_show_skype = true;
      else $this->mygbp_show_skype = false;
    // GB fields vars -- end
  }

	function getData()
	{
/***///	echo '<script type="text/javascript">alert("function getData läuft");</script>';
		if (file_exists($this->configFile) and file_exists($this->mygbp_infoFile)) {
			require($this->configFile);
			require($this->mygbp_infoFile);
			$this->config = $MyGuestbookConfig;
			$this->mygbp_info = $MyGuestbookPlusInfo;
		}
		else {
			$this->config = array('label'=>'MyGuestbookPlus', 'order'=>'last', 'dateFormat'=>'n/j/Y', 'perPage'=>'5', 'entry'=>array());
			$this->mygbp_info = array('moderateSubmits'=>'1', 'show_email'=>'1', 'show_url'=>'1', 'show_country'=>'1', 'show_location'=>'1', 'show_icq'=>'1', 'show_skype'=>'1', 'entry'=>array());
			$this->save();
		}
	}

	function countInactive() {
/***///	echo '<script type="text/javascript">alert("function countInactive läuft");</script>';
		if(!empty($this->mygbp_info['moderateSubmits']) and $this->mygbp_info['moderateSubmits'] == '1') {
/***/	$this->numberinactive = 0;
			$this->activearray = array();
			if(isset($this->mygbp_info['entry'])) {
				for($entry = 0; $entry < $this->number; $entry++) {
				  if(isset($this->mygbp_info['entry'][$entry]['active']) and $this->mygbp_info['entry'][$entry]['active'] == '0') {
/***/				$this->numberinactive++;
					} else {
						$this->activearray[$entry] = 'active';
					}
				}
/***///	echo '<script type="text/javascript">alert("inactive: ' . $this->numberinactive . '");</script>';
/***/// var_dump($this->activearray);

				$this->activecounter = count($this->activearray, 1);
			}
		} else {
			$this->activecounter = $this->number;
/***/	$this->numberinactive = 0;
		}
/***///	echo '<script type="text/javascript">alert("active: ' . $this->activecounter . '");</script>';
	}

	function showEntries()
	{
/***///	echo '<script type="text/javascript">alert("function showEntries läuft");</script>';
		global $addonRelativeCode;
		$page = (isset($_GET['page'])) ? $_GET['page'] : 0;
		$this->number = (isset($this->config['entry'])) ? count($this->config['entry']) : 0;

		$this->countInactive();

		echo '<h2>'.$this->config['label'].'</h2>'."\n";
		echo "<p>" . $this->activecounter . " ".gpOutput::GetAddonText('Entries').' - '.common::Link('Special_MyGuestbookPlus', gpOutput::GetAddonText('Sign Guestbook'), 'cmd=sign').'</p>'."\n";
/***/	echo '<p class="hiddencount">('.$this->numberinactive.' '.gpOutput::SelectText('hidden').')</p>';

		if ($this->config['perPage'] == 'all') {
			if ($this->config['order'] == 'last') {
				$i = $this->number-1;
				$to = -1;
			}
			else {
				$i = 0;
				$to = $this->number;
			}
		} else {

/***/// echo '<script type="text/javascript">alert("Vorher:\r\n\r\ni: '.$i.'\r\npage: '.$page.'\r\nperPage: '.$this->config['perPage'].'\r\nto: '.$to.'");</script>';       

			if ($this->config['order'] == 'last') {
				$i = ($this->number - 1) - ($page * (int)$this->config['perPage']);
				if ($i < 0) $i = 0;
				if ($i >= $this->number) $i = $this->number-1;
				$to = $i - (int)$this->config['perPage'];
				if ($to < -1) $to = -1;
			}
			else {
				$i = $page * (int)$this->config['perPage'];
				if ($i < 0) $i = 0;
				$to = $i + (int)$this->config['perPage'];
				if ($to > $this->number) $to = $this->number;
			}

/***/// echo '<script type="text/javascript">alert("Nachher:\r\n\r\ni: '.$i.'\r\npage: '.$page.'\r\nperPage: '.$this->config['perPage'].'\r\nto: '.$to.'");</script>';

		}

		while ($i != $to) {
 			if($this->mygbp_info['entry'][$i]['active'] == '1' or empty($this->mygbp_info['moderateSubmits']) or $this->mygbp_info['moderateSubmits'] == '0')
			{
				echo '<div class="myguestbook_entry">';
					echo '<h2 class="myguestbook_name">';

						// URL data, set as link on the name if available
						if($this->mygbp_info['show_url'] == '1' && $this->mygbp_info['entry'][$i]['url']) echo '<a href="' . $this->mygbp_info['entry'][$i]['url'] . '">';

						echo $this->config['entry'][$i]['name'];
						if($this->mygbp_info['show_url'] == '1' && $this->mygbp_info['entry'][$i]['url']) echo '&nbsp;<img src="' . $addonRelativeCode . '/images/icons/www24.png" alt="Website: " /></a>';

					echo '</h2>';

					echo '<div class="myguestbook_header">';
						echo '<div class="myguestbook_info">'.date($this->config['dateFormat'], $this->config['entry'][$i]['date']).'</div>';

					// MyGuestbook Plus data - start
						echo '<div class="mygbp_data">';

/***/ echo '<span class="message_id">ID: ' . $i . '</span>';

							// Country and Location data
							$mapStr = false;
							$locationStr = 0;
							if($this->mygbp_info['show_country'] == '1' && $this->mygbp_info['show_location'] == '1' && $this->mygbp_info['entry'][$i]['country'] && $this->mygbp_info['entry'][$i]['location']) {
								$mapStr = '<span class="text">';
								$mapStr .= $this->mygbp_info['entry'][$i]['location'];
								$mapStr .= ', ';
								$mapStr .= $this->mygbp_info['entry'][$i]['country'];
								$mapStr .= '</span>';

								$locationStr = 1; // location AND country given
							}
							else if($this->mygbp_info['show_country'] == '1' && $this->mygbp_info['entry'][$i]['country']) {
								$mapStr = '<span class="text">' . $this->mygbp_info['entry'][$i]['country'] . '</span>';
								$locationStr = 2; // only country given 
							}
							else if($this->mygbp_info['show_location'] == '1' && $this->mygbp_info['entry'][$i]['location']) {
								$mapStr = '<span class="text">' . $this->mygbp_info['entry'][$i]['location'] . '</span>';
								$locationStr = 3; // only location given
							}

							if($mapStr != false) {
								$mapImg = '<img src="' . $addonRelativeCode . '/images/icons/Map24.png" alt="Location: " />';
								if($locationStr == 1) $gMapsStr = $this->mygbp_info['entry'][$i]['location'] . ',+' . $this->mygbp_info['entry'][$i]['country'];
								else if($locationStr == 2) $gMapsStr = $this->mygbp_info['entry'][$i]['country'];
								else if($locationStr == 3) $gMapsStr = $this->mygbp_info['entry'][$i]['location'];

								echo '<a href="http://maps.google.de/maps?q=' . $gMapsStr . '">' . $mapImg . '</a>';
								echo $mapStr;
							}

							// Email data
							if($this->mygbp_info['show_email'] == '1' && $this->mygbp_info['entry'][$i]['email']) {
								echo '<img src="' . $addonRelativeCode . '/images/icons/Email24.png" alt="Email: " />';
								echo '<img src="' . $this->txtToPng($this->mygbp_info['entry'][$i]['email']) . '" class="emailpng" alt="Image with email address" />';
							}

							// ICQ data
							if($this->mygbp_info['show_icq'] == '1' && $this->mygbp_info['entry'][$i]['icq']) echo '<a href="http://wwp.icq.com/' . $this->mygbp_info['entry'][$i]['icq'] . '"><img src="' . $addonRelativeCode . '/images/icons/Icq24.png" alt="ICQ: " /></a><span class="text">' . $this->mygbp_info['entry'][$i]['icq'] . '</span>';

							// Skype data
							if($this->mygbp_info['show_skype'] == '1' && $this->mygbp_info['entry'][$i]['skype']) echo '<a href="skype:' . $this->mygbp_info['entry'][$i]['skype'] . '?call"><img src="' . $addonRelativeCode . '/images/icons/Skype24.png" alt="Skype: " /></a><span class="text">' . $this->mygbp_info['entry'][$i]['skype'] . '</span>';

						echo '</div>';
					// MyGuestbook Plus data - end

					echo '</div>';

					echo '<div class="myguestbook_text">'.$this->config['entry'][$i]['text'].'</div>'."\n";
				echo '</div>';

/***///	echo '<script type="text/javascript">alert("shownentriescount: ' . $shownentriescount . '\r\nto: ' . $to . '\r\ncorrectedto: ' . $correctedto . '\r\ni: ' . $i . '");</script>';
 			} else {
        // Placeholder for hidden/inactive entry
        #$hiddenentry = 1;
        if($this->config['perPage'] != 'all') {
	        echo '<div class="myguestbook_entry">';
	          echo '<div class="myguestbook_header">';
	            echo '<div class="myguestbook_info smaller"><span class="message_id">'.gpOutput::GetAddonText('Message').' '.gpOutput::SelectText('disabled').'</span></div>';
	/***/         echo '<div class="mygbp_data"><span class="message_id">ID: ' . $i . '</span></div>';
	          echo '</div>';
	          echo '<div class="myguestbook_text smaller"><span class="message_id">(placeholder text) This entry has yet to be approved by a moderator...</span></div>'."\n";
	        echo '</div>';
				}
      } // end if active

			if ($this->config['order'] == 'last') {
        $i--;
/***/	  /*
         * Here should follow some logic to compensate for inactive/hidden entries in 
         * order to have the preset number of entries per page displayed and especially 
         * to not have empty pages with only 'Older Entries'/'Newer Entries' when there 
         * are multiple inactive entries, which could certainly be considered the worst 
         * case scenario...
         * 
         * Doesn't work, yet, under all possible circumstances, hence #commented out.
         * 
         * #
         * # So far, it does not work (causes browser to load forever) under the 
         * # following condition:
         * #
         * #  !('order' => 'last') && !('perPage' => 'all')
         * #
         * #    => as soon as a page ('Older Entries'/'Newer Entries') other than the
         * #       first page (page0) is being opened...
         */
        #if(isset($hiddenentry) and $hiddenentry == 1 and $this->config['perPage'] != 'all' and $i != $to) $to--; 
			}	else {
			  $i++;
			  #if(isset($hiddenentry) and $hiddenentry == 1 and $this->config['perPage'] != 'all' and $i != $to) $to++;
			}
      #$hiddenentry = 0;
		} // end while

		if ($this->config['perPage'] != 'all') {
			$prev = 'page='.($page-1);
			if (($page-1) <= 0) $prev = '';
			$next = 'page='.($page+1);
			$pageNumber = ceil($this->number / (int)$this->config['perPage'])-1;
			if ($this->config['order'] == 'last') {
				$prevText = gpOutput::GetAddonText('Newer Entries');
				$nextText = gpOutput::GetAddonText('Older Entries');
			}
			else {
				$prevText = gpOutput::GetAddonText('Older Entries');
				$nextText = gpOutput::GetAddonText('Newer Entries');
			}
			if ($page > 0) echo common::Link('Special_MyGuestbookPlus', $prevText, $prev);
			echo ' ';
			if ($page < $pageNumber) echo common::Link('Special_MyGuestbookPlus', $nextText, $next);
		}

		// temp dir cleanup function
		if($this->txtToPngTMPAbsolute != '') $this->TMPDirCleanup($this->txtToPngTMPAbsolute);
	}

  function MyGuestbookPlusFormFields($id=null) {
/***///	echo '<script type="text/javascript">alert("function MyGuestbookPlusFormFields läuft");</script>';

    global $langmessage, $addonRelativeCode;

    $this->setMyGuestbookPlusVars();

    if(isset($id)) {
      $email = (isset($this->mygbp_info['entry'][$id]['email'])) ? $this->mygbp_info['entry'][$id]['email'] : '';
      $url = (isset($this->mygbp_info['entry'][$id]['url'])) ? $this->mygbp_info['entry'][$id]['url'] : '';
      $country = (isset($this->mygbp_info['entry'][$id]['country'])) ? $this->mygbp_info['entry'][$id]['country'] : '';
      $location = (isset($this->mygbp_info['entry'][$id]['location'])) ? $this->mygbp_info['entry'][$id]['location'] : '';
      $icq = (isset($this->mygbp_info['entry'][$id]['icq'])) ? $this->mygbp_info['entry'][$id]['icq'] : '';
      $skype = (isset($this->mygbp_info['entry'][$id]['skype'])) ? $this->mygbp_info['entry'][$id]['skype'] : '';
    } else {
      $email = (isset($_POST['email'])) ? $_POST['email'] : '';
      $url = (isset($_POST['url'])) ? $_POST['url'] : '';
      $country = (isset($_POST['country'])) ? $_POST['country'] : '';
      $location = (isset($_POST['location'])) ? $_POST['location'] : '';
      $icq = (isset($_POST['icq'])) ? $_POST['icq'] : '';
      $skype = (isset($_POST['skype'])) ? $_POST['skype'] : '';
    }


    // JavaScript input checking and button disabling/re-enabling functionality
 	  echo '<tr><td><script language="javascript" type="text/javascript" src="'.$addonRelativeCode.'/scripts/MyGuestbookPlus.js"></script></td></tr>';

    if (common::LoggedIn()) echo '<table>';

    if (common::LoggedIn() && (isset($this->mygbp_info['moderateSubmits']) and $this->mygbp_info['moderateSubmits'] == '1')) {
      $checkedstr = ($this->mygbp_info['entry'][$id]['active'] == '0') ? '' : 'checked="checked" ';
      echo '<tr><td><label for="myguestbook_active_state">'.gpOutput::SelectText('enabled').'</label></td><td><input type="checkbox" name="active" id="myguestbook_active_state" '.$checkedstr.'/></td></tr>';
    }

    // If email field is to be shown
    if($this->mygbp_show_email == true){
      echo '<tr><td><label for="myguestbook_email">'.gpOutput::SelectText('Email').'</label></td><td><input type="text" name="email" id="myguestbook_email" class="text" value="'.$email.'" size="30" onkeyup="showClearButton(this.value, this.name);" onblur="checkInput(this.value, this.name);" /><span id="email" class="clearInput" style="visibility: hidden;" onclick="clearInput(this.id);">x</span></td></tr>';
    }

    // If URL field is to be shown
    if($this->mygbp_show_url == true){
      echo '<tr><td><label for="myguestbook_url">'.gpOutput::SelectText('URL').'</label></td><td><input type="text" name="url" id="myguestbook_url" class="text" value="'.$url.'" size="30" onkeyup="showClearButton(this.value, this.name);" onblur="checkInput(this.value, this.name);" /><span id="url" class="clearInput" style="visibility: hidden;" onclick="clearInput(this.id);">x</span></td></tr>';

    }

    // If country field is to be shown
    if($this->mygbp_show_country == true){
      echo '<tr><td><label for="myguestbook_country">'.gpOutput::SelectText('Country').'</label></td><td><input type="text" name="country" id="myguestbook_country" class="text" value="'.$country.'" size="30" onkeyup="showClearButton(this.value, this.name);" /><span id="country" class="clearInput" style="visibility: hidden;" onclick="clearInput(this.id);">x</span></td></tr>';
    }

    // If location field is to be shown
    if($this->mygbp_show_location == true){
      echo '<tr><td><label for="myguestbook_location">'.gpOutput::SelectText('Location').'</label></td><td><input type="text" name="location" id="myguestbook_location" class="text" value="'.$location.'" size="30" onkeyup="showClearButton(this.value, this.name);" /><span id="location" class="clearInput" style="visibility: hidden;" onclick="clearInput(this.id);">x</span></td></tr>';
    }

    // If ICQ field is to be shown
    if($this->mygbp_show_icq == true){
      echo '<tr><td><label for="myguestbook_icq">'.gpOutput::SelectText('ICQ').'</label></td><td><input type="text" name="icq" id="myguestbook_icq" class="text" value="'.$icq.'" size="30" onkeyup="showClearButton(this.value, this.name);" onblur="checkInput(this.value, this.name);" /><span id="icq" class="clearInput" style="visibility: hidden;" onclick="clearInput(this.id);">x</span></td></tr>';
    }

    // If skype field is to be shown
    if($this->mygbp_show_skype == true){
      echo '<tr><td><label for="myguestbook_skype">'.gpOutput::SelectText('Skype').'</label></td><td><input type="text" name="skype" id="myguestbook_skype" class="text" value="'.$skype.'" size="30" onkeyup="showClearButton(this.value, this.name);" onblur="checkInput(this.value, this.name);" /><span id="skype" class="clearInput" style="visibility: hidden;" onclick="clearInput(this.id);">x</span></td></tr>';
    }
    if (common::LoggedIn()) echo '</table>';

  }

	function formSign()
	{
/***///	echo '<script type="text/javascript">alert("function formSign läuft");</script>';
		global $langmessage, $config, $rootDir;
		$name = (isset($_POST['name'])) ? $_POST['name'] : '';
		$text = (isset($_POST['text'])) ? $_POST['text'] : '';

		common::AddColorBox();

		echo '<script type="text/javascript">$(document).ready(function(){$(".bbcode").colorbox({inline:true,href:"#my_guestbook_help"});$(".preview").click(function(){$("#myguestbook_preview").slideUp(300, function(){$.post("'.$_SERVER['PHP_SELF'].'?cmd=preview", {text:$("#myguestbook_text").val()}, function(data){$("#myguestbook_preview").html(data).slideDown(300);});});});});</script>'."\n";
		echo '<div style="display:none"><div id="my_guestbook_help" class="inline_box">'."\n";
		$this->help();
		echo '</div></div>'."\n";

		echo '<h2>'.gpOutput::GetAddonText('Sign Guestbook').'</h2>'."\n";
		echo '<form action="'.common::GetUrl('Special_MyGuestbookPlus','cmd=save').'" class="myguestbook_form" method="post"><table><tr><td><label for="myguestbook_name">'.gpOutput::GetAddonText('Name').'*</label></td><td><input type="text" name="name" id="myguestbook_name" class="text" value="'.$name.'" size="30" onkeyup="showClearButton(this.value, this.name);" /><span id="name" class="clearInput" style="visibility: hidden;" onclick="clearInput(this.id);">x</span></td></tr>';

    // GB plus vars and fields
    $this->MyGuestbookPlusFormFields();

		echo '<tr><td><label for="myguestbook_text">'.gpOutput::GetAddonText('Text').'*</label></td><td><textarea cols="30" rows="6" name="text" id="myguestbook_text">'.$text.'</textarea><br /><small><a href="'.common::GetUrl('Special_MyGuestbookPlus', 'cmd=help').'" class="bbcode">'.gpOutput::GetAddonText('You can use BBCode').'</a></small></td></tr><tr>'."\n";
		// if reCaptcha	is enabled
		if (!empty($config['recaptcha_public']) and !empty($config['recaptcha_private'])) {
			require_once($rootDir.'/include/thirdparty/recaptchalib.php');
			$lang = $config['recaptcha_language'];
			$recaptchaLangs = array('en', 'nl', 'fr', 'de', 'pt', 'ru', 'es', 'tr');
			if ($lang == 'inherit') {
				$lang = (in_array($config['language'], $recaptchaLangs)) ? $config['language'] : 'en';
			}
			$recaptchaScript = '<script>var RecaptchaOptions = { lang : "'.$lang.'" };</script>';
			echo '<td><label for="captcha">'.gpOutput::GetAddonText('Captcha').'</label></td><td>'.$recaptchaScript.recaptcha_get_html($config['recaptcha_public']).'</td></tr><tr>'."\n";
		}

		if(!empty($this->mygbp_info['moderateSubmits']) and $this->mygbp_info['moderateSubmits'] == '1') {
			echo '<td>&nbsp;</td><td><span class="tobeapproved">New entries must be approved by a moderator before they are being published!<br />Please be patient, and don\'t submit your message multiple times if it\'s not displayed right away.<br />Thank you!</span> <span class="message_id" style="font-size: smaller;">(this text is a place holder)</span></td></tr><tr>';
		}

		echo '<td></td><td><div id="myguestbook_preview" style="display:none"></div><p><input type="submit" class="submit" id="save" name="" value="'.$langmessage['save'].'" /> <script type="text/javascript">document.write(\'<input type="button" class="preview submit" id="preview" value="'.gpOutput::GetAddonText('Preview').'" /> \')</script><input type="reset" class="submit" id="cancel" value="'.$langmessage['cancel'].'" onclick="document.location.href=\''.common::GetUrl('Special_MyGuestbookPlus').'\'" /></p></td></tr></table></form>'."\n";
 	}

	// from special/special_contact.php
	function CheckCaptcha()
	{
/***///	echo '<script type="text/javascript">alert("function CheckCaptcha läuft");</script>';
		global $langmessage, $config, $rootDir;

		if (empty($config['recaptcha_public']) or empty($config['recaptcha_private'])) {
			return true;
		}
		require_once($rootDir.'/include/thirdparty/recaptchalib.php');
		$resp = recaptcha_check_answer($config['recaptcha_private'], $_SERVER['REMOTE_ADDR'], $_POST['recaptcha_challenge_field'], $_POST['recaptcha_response_field']);
		
		if (!$resp->is_valid) {
			message($langmessage['INCORRECT_CAPTCHA']);
			if (common::LoggedIn()) {
				message($langmessage['recaptcha_said'], $resp->error);
			}
			return false;
		}
		return true;
	}

	function saveNewEntry()
	{
/***///	echo '<script type="text/javascript">alert("function saveNewEntry läuft");</script>';
		global $langmessage;

		if (!$this->CheckCaptcha() or !isset($_POST['name']) or !isset($_POST['text']) or empty($_POST['name']) or empty($_POST['text'])) {
			if (!isset($_POST['name']) or empty($_POST['name'])) {
				$field = gpOutput::GetAddonText('Name');
				message($langmessage['OOPS_REQUIRED'], $field);
			}
			if (!isset($_POST['text']) or empty($_POST['text'])) {
				$field = gpOutput::GetAddonText('Text');
				message($langmessage['OOPS_REQUIRED'], $field);
			}
			return false;
		}

		$this->number = (isset($this->config['entry'])) ? count($this->config['entry']) : 0;

    if($this->checkMyGuestbookPlusData($this->number) == false) {
      message($langmessage['OOPS']);
      return false;
    }

		$this->config['entry'][$this->number]['date'] = time();
		$this->config['entry'][$this->number]['name'] = $_POST['name'];
		$this->config['entry'][$this->number]['text'] = $this->parseBBCode($_POST['text']);

		if(!empty($this->mygbp_info['moderateSubmits']) and $this->mygbp_info['moderateSubmits'] == '1') {
			$this->mygbp_info['entry'][$this->number]['active'] = '0';
		} else {
			$this->mygbp_info['entry'][$this->number]['active'] = '1';
		}

		$this->save();

		return true;
	}

	function parseBBCode(&$text)
	{
/***///	echo '<script type="text/javascript">alert("function parseBBCode läuft");</script>';
		global $addonRelativeCode;
		$smileys = $addonRelativeCode.'/images/smileys/';
		$text = strip_tags(htmlspecialchars($text));
		$text = preg_replace("/\015\012|\015|\012/", "\n", $text);
		$text = str_replace(':)', '<img src="'.$smileys.'smile.gif" alt=" " />', $text);
		$text = str_replace(';)', '<img src="'.$smileys.'wink.gif" alt=" " />', $text);
		$text = str_replace(':P', '<img src="'.$smileys.'tongue.gif" alt=" " />', $text);
		$text = str_replace(':D', '<img src="'.$smileys.'biggrin.gif" alt=" " />', $text);
		$text = str_replace(':o', '<img src="'.$smileys.'redface.gif" alt=" " />', $text);
		$text = str_replace(':(', '<img src="'.$smileys.'frown.gif" alt=" " />', $text);
		$text = str_replace(':mad:', '<img src="'.$smileys.'mad.gif" alt=" " />', $text);
		$text = str_replace(':confused:', '<img src="'.$smileys.'confused.gif" alt=" " />', $text);
		$text = str_replace(':rolleyes:', '<img src="'.$smileys.'rolleyes.gif" alt=" " />', $text);
		$text = str_replace(':cool:', '<img src="'.$smileys.'cool.gif" alt=" " />', $text);
		$text = str_replace(':eek:', '<img src="'.$smileys.'eek.gif" alt=" " />', $text);
		$text = preg_replace('#\[b\](.*)\[/b\]#isU', "<strong>$1</strong>", $text);
		$text = preg_replace('#\[i\](.*)\[/i\]#isU', "<em>$1</em>", $text);
		$text = preg_replace('#\[u\](.*)\[/u\]#isU', "<u>$1</u>", $text);
		$text = preg_replace('#\[s\](.*)\[/s\]#isU', "<strike>$1</strike>", $text);
		$text = preg_replace('#\[color=(.*)\](.*)\[/color\]#isU', "<span style=\"color:$1\">$2</span>", $text);
		$text = preg_replace('#\[size=(8|10|12)\](.*)\[/size\]#isU', "<span style=\"font-size:$1pt\">$2</span>", $text);
		$text = preg_replace('#\[url\](.*)\[/url\]#isU', "<a href=\"$1\">$1</a>", $text);
		$text = preg_replace('#\[url=(.*)\](.*)\[/url\]#isU', "<a href=\"$1\">$2</a>", $text);
		$text = preg_replace('#\[email\](.*)\[/email\]#isU', "<a href=\"mailto:$1\">$1</a>", $text);
		$text = preg_replace('#\[img\](.*)\[/img\]#isU', "<img src=\"$1\" alt=\"$1\" />", $text);
		$text = preg_replace('#\[quote\](.*)\[/quote\]#isU', "<blockquote><p>$1</p></blockquote>", $text);
		$text = preg_replace('#\[code\](.*)\[/code\]#isU', "<code>$1</code>", $text);
		$text = preg_replace('#\[list\](.*)\[/list\]#isU', "<ul>$1\n</ul>", $text);
		$text = preg_replace('#\[list=(1|a)\](.*)\[/list\]#isU', "<ol type=\"$1\">$2</ol>", $text);
		$text = preg_replace('#\[\*\]#isU', "\n[*]", $text);
		$text = preg_replace('#\[\*\](.*)\n#isU', "<li>$1</li>", $text);
		$text = preg_replace('#\n\n#isU', "</p>\n<p>", $text);

		return "<p>$text</p>";
	}

	function adminShowEntries()
	{
/***///	echo '<script type="text/javascript">alert("function adminShowEntries läuft");</script>';
		global $langmessage, $addonRelativeCode;
		$this->number = (isset($this->config['entry'])) ? count($this->config['entry']) : 0;

		$this->countInactive();

		echo '<div style="display:none"><div id="myguestbook_entry_delete" class="inline_box"><form action="'.common::getUrl('Special_MyGuestbookPlus').'" method="post"><p>'.$langmessage['delete_confirm'].'</p><p style="text-align:right"><input type="hidden" name="id" value="" /><input type="hidden" name="cmd" value="delete" /><input type="submit" name="aaa" value="'.$langmessage['delete'].'" /><input type="button" name="" value="Cancel" onclick="javascript:$(this).colorbox.close()" /></p></form></div></div>'."\n";
		echo '<h2>'.$this->config['label'].'</h2>';

		// Link to admin config
		echo '<div style="float: right;"><a href="'.common::GetUrl('Special_MyGuestbookPlus', 'cmd=config').'">'.gpOutput::SelectText('configuration').'</a></div>';

		echo "<div>{$this->number} ".gpOutput::GetAddonText('Entries')." <span class=\"hiddencount\">({$this->numberinactive} ".gpOutput::SelectText('disabled').")</span></div>\n";

		for ($i = 0; $i < $this->number; $i++) {
			$input = '<input type="hidden" name="id" value="'.$i.'" />';

			echo '<h2 class="myguestbook_name">'.$this->config['entry'][$i]['name'].'</h2>
						<div class="fullwidth">'.common::Link(
							'Special_MyGuestbookPlus', $langmessage['edit'],
							'cmd=edit&id='.$i
						).' '.
						common::Link(
							'Special_MyGuestbookPlus', $langmessage['delete'].
							$input,
							'cmd=popup',
							' name="inline_box" rel="#myguestbook_entry_delete"'
						).' - ';

				if($this->mygbp_info['entry'][$i]['active'] == '0') {
					echo '<span class="message_disabled">' . $langmessage['message'] . ' ' . $langmessage['disabled'] . '</span> -- <span class="message_enabled">' . common::Link(
							'Special_MyGuestbookPlus', $langmessage['enable'],
							'cmd=chstate&id='.$i.'&state=show'
					) . '</span></div>';
				} else {
					echo '<span class="message_enabled">' . $langmessage['message'] . ' ' . $langmessage['enabled'] . '</span> -- <span class="message_disabled">' .common::Link(
							'Special_MyGuestbookPlus', $langmessage['disable'],
							'cmd=chstate&id='.$i.'&state=hide'
					) . '</span></div>';
				}

        // JavaScript for tooltip info, from http://www.walterzorn.de/tooltip/tooltip.htm
        echo '<script language="javascript" type="text/javascript" src="'.$addonRelativeCode.'/scripts/wz_tooltip.js"></script>';

				echo '<div class="myguestbook_header">';
					echo '<div class="myguestbook_info">'.
						date($this->config['dateFormat'],$this->config['entry'][$i]['date']);
					echo '</div>';
					echo '<div class="mygbp_data smaller">';
/***/       echo ' <span class="message_id">ID: ' . $i . '</span>';
            if($this->mygbp_info['entry'][$i]['country']) {
              echo '<img src="' . $addonRelativeCode . '/images/icons/Spacer_1x24.png" style="height: 100%" alt=" " />' . gpOutput::GetAddonText('Country') . ': ' . $this->mygbp_info['entry'][$i]['country'];
            }
            if($this->mygbp_info['entry'][$i]['location']) {
              echo '<img src="' . $addonRelativeCode . '/images/icons/Spacer_1x24.png" style="height: 24px" alt=" " />' . gpOutput::GetAddonText('Location') . ': ' . $this->mygbp_info['entry'][$i]['location'];
            }
 						if($this->mygbp_info['entry'][$i]['email']) {
 						  $ttstr = $this->mygbp_info['entry'][$i]['email'];
 						  echo '<img src="' . $addonRelativeCode . '/images/icons/Email24.png" alt="'.$ttstr.'" title="'.$ttstr.'" onmouseover="Tip(\''.'Email: '.$ttstr.'\')" onmouseout="UnTip()" />';
						}
 						if($this->mygbp_info['entry'][$i]['url']) {
              $ttstr = $this->mygbp_info['entry'][$i]['url'];
              echo '<img src="' . $addonRelativeCode . '/images/icons/www24.png" alt="'.$ttstr.'" title="'.$ttstr.'" onmouseover="Tip(\''.'Website: '.$ttstr.'\')" onmouseout="UnTip()" />';
						}
 						if($this->mygbp_info['entry'][$i]['icq']) {
              $ttstr = $this->mygbp_info['entry'][$i]['icq'];
              echo '<img src="' . $addonRelativeCode . '/images/icons/Icq24.png" alt="'.$ttstr.'" title="'.$ttstr.'" onmouseover="Tip(\''.'ICQ#: '.$ttstr.'\')" onmouseout="UnTip()" />';
						}
 						if($this->mygbp_info['entry'][$i]['skype']) {
              $ttstr = $this->mygbp_info['entry'][$i]['skype'];
              echo '<img src="' . $addonRelativeCode . '/images/icons/Skype24.png" alt="'.$ttstr.'" title="'.$ttstr.'" onmouseover="Tip(\''.'Skype: '.$ttstr.'\')" onmouseout="UnTip()" />';
						}
					echo '</div>';
				echo '</div>';
				echo '<div class="myguestbook_text">'.
				$this->config['entry'][$i]['text'].
			'</div><br />'."\n";
		}
	}

	function adminEditEntry()
	{
/***///	echo '<script type="text/javascript">alert("function adminEditEntry läuft");</script>';
		global $langmessage;

		echo '<h2>'.$this->config['label'].' '.$langmessage['edit'].'</h2>';
		if (isset($_REQUEST['id'])) {
			$id = (int)$_REQUEST['id'];
			echo '<form action="'.common::getUrl('Special_MyGuestbookPlus').'" method="post"><h4>'.gpOutput::GetAddonText('Name').'</h4><p><input type="text" name="name" size="30" value="'.$this->config['entry'][$id]['name'].'" /></p>';

      // GB plus vars and fields
      $this->MyGuestbookPlusFormFields($id);

			echo '<h4>'.gpOutput::GetAddonText('Text').'</h4>';
			common::UseFCK($this->config['entry'][$id]['text'], 'text');
			echo '<p><input type="hidden" name="cmd" value="admin_save" /><input type="hidden" name="id" value="'.$id.'" /><input type="hidden" name="date" value="'.$this->config['entry'][$id]['date'].'" /><input id="save" type="submit" name="" value="'.$langmessage['save'].'" /><input type="submit" name="cmd" value="'.$langmessage['cancel'].'" /></p></form>'."\n";
		}
		else {
			message($langmessage['OOPS']);
			$this->adminShowEntries();
		}
	}

	function adminChangeState()
	{
/***///	echo '<script type="text/javascript">alert("function adminChangeState läuft");</script>';
		global $langmessage;

		if (isset($_REQUEST['id']) and isset($_REQUEST['state']) and ($_REQUEST['state'] == 'hide' or $_REQUEST['state'] == 'show')) {
			$id = (int)$_REQUEST['id'];
			$state = $_REQUEST['state'];
/***///	echo '<script type="text/javascript">alert("id: ' . $id . '\r\nactive: \'' . $this->mygbp_info['entry'][$id]['active'] . '\'\r\nnew state: ' . $state . '");</script>';
			if($state == 'hide') {
				$this->mygbp_info['entry'][$id]['active'] = '0';
			}
			else if($state == 'show') {
				$this->mygbp_info['entry'][$id]['active'] = '1';
			}
			$this->save();
		}
		else {
			message($langmessage['OOPS']);
		}
	}

	function checkMyGuestbookPlusData($id=null) {
/***///	echo '<script type="text/javascript">alert("function checkMyGuestbookPlusData läuft");</script>';
    if(
        (!empty($_POST['email']) and !preg_match('/^[\w-.]+@{1}[\w-.]+\.[a-zA-Z]{2,4}$/', $_POST['email'])) 
      or (!empty($_POST['url']) and !preg_match('/^(https?:\/\/)?([\w-]{2,}\.)+[a-zA-Z]{2,4}((\/|\?).*)?$/', $_POST['url'])) 
      /*
       * ICQ#: min 5 digits, normally 8-9 digits, in the future possibly
       * more; pattern: 123456789 or 123-456-789 or 123 456 789
       */ 
      or (!empty($_POST['icq']) and !preg_match('/^([0-9]{3})?(\ *|-)?([0-9]{3})?(\ *|-)?[0-9]{2,3}(\ *|-)?[0-9]{3}$/', $_POST['icq']))
      /*
       * Skype names consist of 6 through 32 characters, must begin
       * with a letter (a-z, no Umlauts), and may contain letters (a-z),
       * numbers, comma (,), full stop (.), underscore (_) and
       * single dash (-)
       * see: https://support.skype.com/faq/FA94/
       */
      or (!empty($_POST['skype']) and !preg_match('/^[a-zA-Z]{1}[a-zA-Z0-9.,-_]{5,31}$/', $_POST['skype']))
      ) {
      return false;
    } else {
      if(!empty($_POST['email'])) $this->mygbp_info['entry'][$id]['email'] = trim($_POST['email']);
      if(!empty($_POST['url'])) {
        if(!preg_match('/^https?:\/\/.*/', $_POST['url'])) $this->mygbp_info['entry'][$id]['url'] = 'http://' . trim($_POST['url']);
        else $this->mygbp_info['entry'][$id]['url'] = trim($_POST['url']);
      }
      if(!empty($_POST['country'])) $this->mygbp_info['entry'][$id]['country'] = trim($_POST['country']);
      if(!empty($_POST['location'])) $this->mygbp_info['entry'][$id]['location'] = trim($_POST['location']);
      if(!empty($_POST['icq'])) {
        $this->mygbp_info['entry'][$id]['icq'] = preg_replace('/\D/', '', trim($_POST['icq']));
      }
      if(!empty($_POST['skype'])) $this->mygbp_info['entry'][$id]['skype'] = trim($_POST['skype']);
      if(!empty($_POST['active']) and $_POST['active'] == "on") {
        $this->mygbp_info['entry'][$id]['active'] = '1';
      } else {
        $this->mygbp_info['entry'][$id]['active'] = '0';
      }
      return true;
    }
	}

	function adminSaveEntry()
	{
/***///	echo '<script type="text/javascript">alert("function adminSaveEntry läuft");</script>';
		global $langmessage;

		if (isset($_POST['name']) and isset($_POST['text']) and isset($_POST['id']) and isset($_POST['date']) and !empty($_POST['name']) and !empty($_POST['text'])) {
			$id = (int)$_POST['id'];
			$this->config['entry'][$id]['name'] = htmlspecialchars($_POST['name']);
			$this->config['entry'][$id]['date'] = (int)$_POST['date'];
			$this->config['entry'][$id]['text'] = $_POST['text'];

			$this->checkMyGuestbookPlusData($id);

			$this->save();

			return true;
		}
		else {
			if (empty($_POST['name'])) message($langmessage['OOPS_REQUIRED'], gpOutput::GetAddonText('Name'));
			if (empty($_POST['text'])) message($langmessage['OOPS_REQUIRED'], gpOutput::GetAddonText('Text'));
		}
		return false;
	}

	function adminDeleteEntry()
	{
/***///	echo '<script type="text/javascript">alert("function adminDeleteEntry läuft");</script>';
		global $langmessage;

		if (isset($_POST['id'])) {
			$id = (int)$_POST['id'];
			array_splice($this->config['entry'], $id, 1);
			array_splice($this->mygbp_info['entry'], $id, 1);
			$this->save();
		}
		else {
			message($langmessage['OOPS']);
		}
	}

	function adminConfig()
	{
/***///	echo '<script type="text/javascript">alert("function adminConfig läuft");</script>';
		global $langmessage, $addonPathCode, $addonRelativeCode;

		$checked_last = ($this->config['order'] == 'last') ? 'checked="checked"' : '';
		$checked_first = ($this->config['order'] != 'last') ? 'checked="checked"' : '';

		// define checked/shown state of mygbp fields
		if($this->mygbp_info['show_email'] == '1') {
			$show_email_yes = 'checked="checked"';
			$show_email_no = '';
		} else {
			$show_email_yes = '';
			$show_email_no = 'checked="checked"';
		}
		if($this->mygbp_info['show_url'] == '1') {
			$show_url_yes = 'checked="checked"';
			$show_url_no = '';
		} else {
			$show_url_yes = '';
			$show_url_no = 'checked="checked"';
		}
		if($this->mygbp_info['show_country'] == '1') {
			$show_country_yes = 'checked="checked"';
			$show_country_no = '';
		} else {
			$show_country_yes = '';
			$show_country_no = 'checked="checked"';
		}
		if($this->mygbp_info['show_location'] == '1') {
			$show_location_yes = 'checked="checked"';
			$show_location_no = '';
		} else {
			$show_location_yes = '';
			$show_location_no = 'checked="checked"';
		}
		if($this->mygbp_info['show_icq'] == '1') {
			$show_icq_yes = 'checked="checked"';
			$show_icq_no = '';
		} else {
			$show_icq_yes = '';
			$show_icq_no = 'checked="checked"';
		}
		if($this->mygbp_info['show_skype'] == '1') {
			$show_skype_yes = 'checked="checked"';
			$show_skype_no = '';
		} else {
			$show_skype_yes = '';
			$show_skype_no = 'checked="checked"';
		}
		if($this->mygbp_info['moderateSubmits'] == '1') {
			$moderateSubmits_yes = 'checked="checked"';
			$moderateSubmits_no = '';
		} else {
			$moderateSubmits_yes = '';
			$moderateSubmits_no = 'checked="checked"';
		}

		echo '<h3>'.$this->config['label'].' '.$langmessage['configuration']."</h3>\n";
		
		echo '<form action="'.common::getUrl('Special_MyGuestbookPlus').'" method="post">
	<table width="100%" class="bordered">
		<thead>
			<tr>
				<th>Option</th>
				<th>Value</th>
				<th>Default</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>Label</td>
				<td>
					<input type="text" name="label" size="30" value="'.htmlspecialchars($this->config['label']).'" />
				</td>
				<td>MyGuestbookPlus</td>
			</tr>
			<tr>
				<td>Entries per Page<br /><small>You can also use \'all\'</small></td>
				<td>
					<input type="text" id="perPage" name="perPage" size="30" value="'.htmlspecialchars($this->config['perPage']).'" onblur="checkPerPage(this.value)" />
				</td>
				<td>5</td>
			</tr>
			<tr>
				<td>Order<br /><small>\'last\' or \'first\'</small></td>
				<td>
					<input type="radio" id="last" name="order" value="last" '.$checked_last.' />
						<label for="last">newest first</label>
					<input type="radio" id="first" name="order" value="first" '.$checked_first.' />
						<label for="first">oldest first</label>
				</td>
				<td>newest first</td>
			</tr>
			<tr>
				<td>Date Format<br /><small>(<a href="http://php.net/manual/en/function.date.php">About</a>)</small><br /><small>Example: j.n.Y H:i<br />(for format like 1.01.2001 12:00)</small></td>
				<td>
					<input type="text" name="dateFormat" size="30" value="'.htmlspecialchars($this->config['dateFormat']).'" />
				</td>
				<td>n/j/Y</td>
			</tr>
			<tr><td colspan="3">&nbsp;</td></tr>
			<tr>
				<td>Show Email field?</td>
				<td>
					<input type="radio" name="show_email" value="1" '.$show_email_yes.' />
						<label>yes</label>
					<input type="radio" name="show_email" value="0" '.$show_email_no.' />
						<label>no</label>
				</td>
				<td>yes</td>
			</tr>
			<tr>
				<td>Show URL/Website field?</td>
				<td>
					<input type="radio" name="show_url" value="1" '.$show_url_yes.' />
						<label>yes</label>
					<input type="radio" name="show_url" value="0" '.$show_url_no.' />
						<label>no</label>
				</td>
				<td>yes</td>
			</tr>
			<tr>
				<td>Show Country field?</td>
				<td>
					<input type="radio" name="show_country" value="1" '.$show_country_yes.' />
						<label>yes</label>
					<input type="radio" name="show_country" value="0" '.$show_country_no.' />
						<label>no</label>
				</td>
				<td>yes</td>
			</tr>
			<tr>
				<td>Show Location/City field?</td>
				<td>
					<input type="radio" name="show_location" value="1" '.$show_location_yes.' />
						<label>yes</label>
					<input type="radio" name="show_location" value="0" '.$show_location_no.' />
						<label>no</label>
				</td>
				<td>yes</td>
			</tr>
			<tr>
				<td>Show ICQ# field?</td>
				<td>
					<input type="radio" name="show_icq" value="1" '.$show_icq_yes.' />
						<label>yes</label>
					<input type="radio" name="show_icq" value="0" '.$show_icq_no.' />
						<label>no</label>
				</td>
				<td>yes</td>
			</tr>
			<tr>
				<td>Show Skype name field?</td>
				<td>
					<input type="radio" name="show_skype" value="1" '.$show_skype_yes.' />
						<label>yes</label>
					<input type="radio" name="show_skype" value="0" '.$show_skype_no.' />
						<label>no</label>
				</td>
				<td>yes</td>
			</tr>
			<tr><td colspan="3">&nbsp;</td></tr>
			<tr>
				<td>New entries must be approved by a<br />moderator before being published?</td>
				<td>
					<input type="radio" name="moderateSubmits" value="1" '.$moderateSubmits_yes.' />
						<label>yes</label>
					<input type="radio" name="moderateSubmits" value="0" '.$moderateSubmits_no.' />
						<label>no</label>
				</td>
				<td>yes</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<input type="hidden" name="cmd" value="save_config" />
					<input type="submit" id="save" name="" value="'.$langmessage['save'].'" />
					<input type="submit" name="cmd" value="'.$langmessage['cancel'].'" />
				</td>
				<td>&nbsp;</td>
			</tr>
		</tbody>
	</table>
</form>
<script language="javascript" type="text/javascript" src="'.$addonRelativeCode.'/scripts/MyGuestbookPlus.js"></script>'."\n";
		echo '<h4>Captcha</h4><p>If you want to protect your Guestbook with a Captcha you can use the service of <a href="http://recaptcha.net/whyrecaptcha.html">reCaptcha</a>. Registration is free.<br />There you get one pair of keys wich you insert and save in the '.common::Link('Admin_Configuration', 'Admin Configuration').'. That\'s it!<br />Automatically your Guestbook and even your contact form will be protected.</p>'."\n";
		echo '<h4>Style</h4><p>There\'s a little stylesheet for the BBCode help site. You can open it from "<a href="'.$addonRelativeCode.'/style.css">'.$addonPathCode.'/style.css</a>" and edit it with every Texteditor.</p><p>For styling you have \'h2.myguestbook_name\', \'div.myguestbook_info\', \'div.myguestbook_text\', \'form.myguestbook_form\', \'input#myguestbook_name\' and \'textarea#myguestbook_text\'. But I hope this will be implemented in every template in the future.</p>'."\n";
	}

	function adminSaveConfig()
	{
/***///	echo '<script type="text/javascript">alert("function adminSaveConfig läuft");</script>';
		global $langmessage, $rootDir;
		$pages_file = $rootDir.'/data/_site/pages.php';
		include $pages_file;
		
		$this->config['label'] = (isset($_POST['label']) and !empty($_POST['label'])) ? htmlspecialchars($_POST['label']) : 'MyGuestbookPlus';
		$this->config['dateFormat'] = $_POST['dateFormat'];
		$this->config['order'] = $_POST['order'];
		$this->config['perPage'] = ((int)$_POST['perPage'] > 0 or $_POST['perPage'] == 'all') ? $_POST['perPage'] : '1';

		$this->mygbp_info['show_email'] = $_POST['show_email'];
		$this->mygbp_info['show_url'] = $_POST['show_url'];
		$this->mygbp_info['show_country'] = $_POST['show_country'];
		$this->mygbp_info['show_location'] = $_POST['show_location'];
		$this->mygbp_info['show_icq'] = $_POST['show_icq'];
		$this->mygbp_info['show_skype'] = $_POST['show_skype'];
		$this->mygbp_info['moderateSubmits'] = $_POST['moderateSubmits'];

		if ($this->config['label'] == $pages['gptitles']['Special_MyGuestbookPlus']['label']) {
			$this->save();
		}
		else {
			if ($this->saveConfig() and $this->savePages($this->config['label'])) {
				message($langmessage['SAVED']);
				message('To see the changes taking effect please '.common::Link('Special_MyGuestbookPlus', 'reload', 'cmd=config').'.');
			}
			else {
				message($langmessage['OOPS']);
			}
		}
	}

	function save()
	{
/***///	echo '<script type="text/javascript">alert("function save läuft");</script>';
		global $langmessage;

 		if ($this->saveConfig()) {
			message($langmessage['SAVED']);
		}
		else {
			message($langmessage['OOPS']);
		}
	}

	function saveConfig()
	{
/***///	echo '<script type="text/javascript">alert("function saveConfig läuft");</script>';

		/* Fill up empty indices in $this->mygbp_info['entry'] for backward
		 * compatibility purposes and seemless deletion of entries */
		$this->number = (isset($this->config['entry'])) ? count($this->config['entry']) : 0;
		for($i = 0; $i < $this->number; $i++) {
			if(!isset($this->mygbp_info['entry'][$i]['active'])) $this->mygbp_info['entry'][$i]['active'] = '';
		} ksort($this->mygbp_info['entry']);

		$olddatasaved = gpFiles::SaveArray($this->configFile, 'MyGuestbookConfig', $this->config);
		$newdatasaved = gpFiles::SaveArray($this->mygbp_infoFile, 'MyGuestbookPlusInfo', $this->mygbp_info);
		if($olddatasaved === true && $newdatasaved === true) return true;
	}

	function savePages(&$label)
	{
/***///	echo '<script type="text/javascript">alert("function savePages läuft");</script>';
		global $rootDir;
		$pages_file = $rootDir.'/data/_site/pages.php';
		include $pages_file;
		
		$pages['gptitles']['Special_MyGuestbookPlus']['label'] = $label;

		if (gpFiles::SaveArray($pages_file, 'pages', $pages)) {
			return true;
		}
		return false;
	}

	function txtToPng($text) {
/***///	echo '<script type="text/javascript">alert("function txtToPng läuft");</script>';
	
		// check for and create TMP dir for images
		global $rootDir;
		$txtToPngTMP = '/data/_cache/imageTMP/';
		// create paths
		$this->txtToPngTMPAbsolute = $rootDir.$txtToPngTMP;
		$txtToPngTMPWebpath = $GLOBALS['dirPrefix'].$txtToPngTMP;

		if(!is_dir($this->txtToPngTMPAbsolute)) mkdir($this->txtToPngTMPAbsolute, 0700);

		$fontNr = 4; // refers to system font
		$imgWidth = imagefontwidth($fontNr) * strlen($text);
		$imgHeight = imagefontheight($fontNr);

		// create empty canvas
		$img = imagecreate($imgWidth, $imgHeight);
		// background transparency (or color)
		imagecolorallocatealpha($img,0x00,0x00,0x00,127);
		//imagecolorallocate($img, 200, 200, 200);

		// declare font color to use
		$fontColor = imagecolorallocate($img, 0, 0, 0);

		imagestring($img, $fontNr, 0, 0, $text, $fontColor);

		// filename creation
		$imgFileName = (microtime(true) * 10000) . '_' . rand(100, 999) . rand(100, 999) . '.png';
		$imgFileAbsoluteName = $this->txtToPngTMPAbsolute . $imgFileName;
		$imgFileWebName = $txtToPngTMPWebpath . $imgFileName;

		// create PNG file
		header('Content-type: image/png');
		imagepng($img, $imgFileAbsoluteName);
		
		// delete image from memory
		imagedestroy($img);

		return $imgFileWebName;
	}

	function TMPDirCleanup($tmpDir) {
/***///	echo '<script type="text/javascript">alert("function TMPDirCleanup läuft");</script>';
/***///	echo '<script type="text/javascript">alert("tmpDir: '.$tmpDir.'");</script>';
		$TMPDirContent = scandir($tmpDir);
/***///	var_dump($TMPDirContent);
		if($TMPDirContent != false) {
			foreach($TMPDirContent as $key => $filename) {
				if($TMPDirContent[$key] != '.' && $TMPDirContent[$key] != '..') {
/***///			echo '<script type="text/javascript">alert("TMPDirContent: '.$TMPDirContent[$key].' - filemtime: '.filemtime($tmpDir . $TMPDirContent[$key]).'\r\ntime(): '.time().'");</script>';
					if((time() - filemtime($tmpDir . $filename)) > 60) unlink($tmpDir . $filename);
				}
			}
		}
	}

	function help()
	{
/***///	echo '<script type="text/javascript">alert("function help läuft");</script>';
		global $addonRelativeCode;

		echo '<table class="bordered"><thead><tr><th>BBCode</th><th>Effect</th></tr></thead><tbody><tr><td><code>[b]bolded text[/b]</code></td><td><b>bolded text</b></td></tr><tr><td><code>[i]italicized text[/i]</code></td><td><i>italicized text</i></td></tr><tr><td><code>[u]underlined text[/u]</code></td><td><span style="text-decoration:underline;">underlined text</span></td></tr><tr><td><code>[s]strikethrough text[/s]</code></td><td><s>strikethrough text</s></td></tr><tr><td><code>[url]http://example.org[/url]</code></td><td><a href="http://example.org" rel="nofollow">http://example.org</a></td></tr><tr><td><code>[url=http://example.com]Example[/url]</code></td><td><a href="http://example.com" rel="nofollow">Example</a></td></tr><tr><td><code>[email]mail@mail.com[/email]</code></td><td><a href="mailto:mail@mail.com">mail@mail.com</a></td></tr><tr><td><code>[img]http://example.com/book.png[/img]</code></td><td><img src="'.$addonRelativeCode.'/images/book.png" width="54" height="50" alt="book.png" /></td></tr><tr><td><code>[quote]quoted text[/quote]</code></td><td><blockquote><p>quoted text</p></blockquote></td></tr><tr><td><code>[code]monospaced text[/code]</code></td><td><code>monospaced text</code></td></tr><tr><td><code>[size=8]Small Text[/size]</code><br /><small>(8, 10, 12)</small></td><td><span style="font-size:8pt">Small Text</span></td></tr><tr><td><code>[color=red]Red Text[/color]</code><br /><small>or</small><br /><code>[color=#FF0000]Red Text[/color]</code></td><td><span style="color:#f00">Red Text</span></td></tr><tr><td><code>[list]<br />[*]First Item<br />[*]Second Item<br />[/list]</code><br /><small>(Also allowed <code>[list=1]</code> or <code>[list=a]</code>)</small></td><td><ul class="help"><li>First Item</li><li>Second Item</li></ul></td></tr></tbody></table>'."\n";
		$smileys = $addonRelativeCode.'/images/smileys/';
		echo '<table class="bordered"><thead><tr><th>Smiley</th><th>Image</th></tr></thead><tbody><tr><td>:)</td><td><img src="'.$smileys.'smile.gif" alt=" " /></td></tr><tr><td>;)</td><td><img src="'.$smileys.'wink.gif" alt=" " /></td></tr><tr><td>:P</td><td><img src="'.$smileys.'tongue.gif" alt=" " /></td></tr><tr><td>:D</td><td><img src="'.$smileys.'biggrin.gif" alt=" " /></td></tr><tr><td>:o</td><td><img src="'.$smileys.'redface.gif" alt=" " /></td></tr><tr><td>:(</td><td><img src="'.$smileys.'frown.gif" alt=" " /></td></tr><tr><td>:mad:</td><td><img src="'.$smileys.'mad.gif" alt=" " /></td></tr><tr><td>:confused:</td><td><img src="'.$smileys.'confused.gif" alt=" " /></td></tr><tr><td>:rolleyes:</td><td><img src="'.$smileys.'rolleyes.gif" alt=" " /></td></tr><tr><td>:cool:</td><td><img src="'.$smileys.'cool.gif" alt=" " /></td></tr><tr><td>:eek:</td><td><img src="'.$smileys.'eek.gif" alt=" " /></td></tr></tbody></table>';
		//echo '<p>'.common::Link('Special_MyGuestbookPlus', gpOutput::GetAddonText('Back'), 'cmd=sign').'</p>';
	}

	function about()
	{
/***///	echo '<script type="text/javascript">alert("function about läuft");</script>';
		global $langmessage;

		echo '<h3>MyGuestbook '.$langmessage['about'].'</h3>'."\n";
		echo '<p>Version '.$this->version.'</p><p>Licensed under version 3 of the <a href="http://www.gnu.org/licenses/gpl-3.0.html">GNU General Public License</a></p><p>Copyright 2010 Stefan Benicke (<a href="http://www.opusonline.at/">opusonline.at</a>)</p><p>Copyright 2010 Stefan Benicke (<a href="http://www.opusonline.at/">opusonline.at</a>)</p><p>Copyright 2012 Rico Koch (<a href="http://nixag.com/">nixag.com</a>)</p>'."\n";
	}
}
