<?php defined('is_running') or die('Not an entry point...');

class Theme_Colors_Changer
{
	public $style = '';

	public $styleDir = '';
	public $cmd = '';
	public $where = '';
	public $targetDir = '';
	public $view = 'a';

	public $colors = array ( // html colors
	'Aliceblue' => 'F0F8FF', 'Antiquewhite' => 'FAEBD7', 'Aqua' => '00FFFF',
	'Aquamarine' => '7FFFD4', 'Azure' => 'F0FFFF', 'Beige' => 'F5F5DC',
	'Bisque' => 'FFE4C4', 'Black' => '000000', 'Blanchedalmond' => 'FFEBCD',
	'Blue' => '0000FF', 'Blueviolet' => '8A2BE2', 'Brown' => 'A52A2A',
	'Burlywood' => 'DEB887', 'Cadetblue' => '5F9EA0', 'Chartreuse' => '7FFF00',
	'Chocolate' => 'D2691E', 'Coral' => 'FF7F50', 'Cornflowerblue' => '6495ED',
	'Cornsilk' => 'FFF8DC', 'Crimson' => 'DC143C', 'Cyan' => '00FFFF',
	'Darkblue' => '00008B', 'Darkcyan' => '008B8B', 'Darkgoldenrod' => 'B8860B',
	'Darkgray' => 'A9A9A9', 'Darkgreen' => '006400', 'Darkkhaki' => 'BDB76B',
	'Darkmagenta' => '8B008B','Darkolivegreen' => '556B2F','Darkorange' => 'FF8C00',
	'Darkorchid' => '9932CC','Darkred' => '8B0000','Darksalmon' => 'E9967A',
	'Darkseagreen' => '8FBC8F','Darkslateblue' => '483D8B','Darkslategray' => '2F4F4F',
	'Darkturquoise' => '00CED1','Darkviolet' => '9400D3','Deeppink' => 'FF1493',
	'Deepskyblue' => '00BFFF','Dimgray' => '696969','Dodgerblue' => '1E90FF',
	'Firebrick' => 'B22222','Floralwhite' => 'FFFAF0','Forestgreen' => '228B22',
	'Fuchsia' => 'FF00FF','Gainsboro' => 'DCDCDC','Ghostwhite' => 'F8F8FF',
	'Gold' => 'FFD700','Goldenrod' => 'DAA520','Gray' => '808080',
	'Green' => '008000','Greenyellow' => 'ADFF2F','Honeydew' => 'F0FFF0',
	'Hotpink' => 'FF69B4','Indianred' => 'CD5C5C','Indigo' => '4B0082',
	'Ivory' => 'FFFFF0','Khaki' => 'F0E68C','Lavender' => 'E6E6FA',
	'Lavenderblush' => 'FFF0F5', 'Lawngreen' => '7CFC00', 'Lemonchiffon' => 'FFFACD',
	'Lightblue' => 'ADD8E6', 'Lightcoral' => 'F08080', 'Lightcyan' => 'E0FFFF',
	'Lightgoldenrodyellow' => 'FAFAD2', 'Lightgreen' => '90EE90', 'Lightgrey' => 'D3D3D3',
	'Lightpink' => 'FFB6C1', 'Lightsalmon' => 'FFA07A', 'Lightseagreen' => '20B2AA',
	'Lightskyblue' => '87CEFA', 'Lightslategray' => '778899', 'Lightsteelblue' => 'B0C4DE',
	'Lightyellow' => 'FFFFE0', 'Lime' => '00FF00', 'Limegreen' => '32CD32',
	'Linen' => 'FAF0E6', 'Magenta' => 'FF00FF', 'Maroon' => '800000',
	'Mediumauqamarine' => '66CDAA', 'Mediumblue' => '0000CD', 'Mediumorchid' => 'BA55D3',
	'Mediumpurple' => '9370D8', 'Mediumseagreen' => '3CB371', 'Mediumslateblue' => '7B68EE',
	'Mediumspringgreen' => '00FA9A', 'Mediumturquoise' => '48D1CC', 'Mediumvioletred' => 'C71585',
	'Midnightblue' => '191970', 'Mintcream' => 'F5FFFA', 'Mistyrose' => 'FFE4E1',
	'Moccasin' => 'FFE4B5', 'Navajowhite' => 'FFDEAD', 'Navy' => '000080',
	'Oldlace' => 'FDF5E6', 'Olive' => '808000', 'Olivedrab' => '688E23',
	'Orange' => 'FFA500', 'Orangered' => 'FF4500', 'Orchid' => 'DA70D6',
	'Palegoldenrod' => 'EEE8AA', 'Palegreen' => '98FB98', 'Paleturquoise' => 'AFEEEE',
	'Palevioletred' => 'D87093', 'Papayawhip' => 'FFEFD5', 'Peachpuff' => 'FFDAB9',
	'Peru' => 'CD853F', 'Pink' => 'FFC0CB', 'Plum' => 'DDA0DD',
	'Powderblue' => 'B0E0E6', 'Purple' => '800080', 'Red' => 'FF0000',
	'Rosybrown' => 'BC8F8F', 'Royalblue' => '4169E1', 'Saddlebrown' => '8B4513',
	'Salmon' => 'FA8072', 'Sandybrown' => 'F4A460', 'Seagreen' => '2E8B57',
	'Seashell' => 'FFF5EE', 'Sienna' => 'A0522D', 'Silver' => 'C0C0C0',
	'Skyblue' => '87CEEB', 'Slateblue' => '6A5ACD', 'Slategray' => '708090',
	'Snow' => 'FFFAFA', 'Springgreen' => '00FF7F', 'Steelblue' => '4682B4',
	'Tan' => 'D2B48C', 'Teal' => '008080', 'Thistle' => 'D8BFD8',
	'Tomato' => 'FF6347', 'Turquoise' => '40E0D0', 'Violet' => 'EE82EE',
	'Wheat' => 'F5DEB3', 'White' => 'FFFFFF', 'Whitesmoke' => 'F5F5F5',
	'Yellow' => 'FFFF00', 'Yellowgreen' => '9ACD32' );

	function __construct()
	{
		global $dataDir, $config;
		//echo "Creating Theme_Colors_Customizer\n";
		parse_str($_SERVER['QUERY_STRING']);
		if (isset($cmd))
			$this->cmd = $cmd;
		if (isset($_POST['duplicate']))
			$this->cmd = 'duplicate';
		if (isset($view))
			$this->view = strtolower($view);
		if (isset($where))
			$this->where = $where;
		if (isset($_POST['edited_where']))
			$this->where = $_POST['edited_where'];
		if (isset($theme))
			$this->style = $theme;
		if (isset($_POST['edited_style']))
			$this->style = $_POST['edited_style'];
		if ($this->where=='local')
		{
			if (isset($theme))
				$this->styleDir = $dataDir.'/themes/'.$theme;
			if (isset($_POST['edited_style']))
			{
				$this->styleDir = $dataDir.'/themes/'.$_POST['edited_style'];
			}
			$theme = explode('/',$this->style,2);
			if (isset($_POST['duplicate']))
			{
				$this->targetDir = $dataDir.'/themes/'.$theme[0].'/'.$_POST['new_style'];
			}
		}
		if ($this->where=='remote')
		{
			$theme = explode('/',$this->style,2);
			if (isset($theme[1]))
			{
				foreach ($config['themes'] as $key => $value)
					if ($value['name']==$theme[0])
						break;
				$this->styleDir = $dataDir.'/data/_themes/'.$key.'/'.$theme[1];
			}
			if (isset($_POST['duplicate']))
			{
				$this->targetDir = $dataDir.'/data/_themes/'.$key.'/'.$_POST['new_style'];
			}
		}
	}

	function Show_Themes_List($refresh='')
	{
		global $page, $addonRelativeCode, $config, $gpLayouts, $dataDir, $langmessage, $addonFolderName;
		$page->head .= '<style type="text/css"> #themes-table td { padding: 1em; color:black; background-color:white; } #themes-table tr:hover > td { color: #a00; text-decoration:underline; } </style>'.PHP_EOL;
		$all_themes = gpFiles::readDir($dataDir.'/themes',1);
		//print_r($all_themes);
		//echo '<pre>'; print_r($gpLayouts); echo '</pre>';

		echo '<div style="float:right">'.common::Link('Admin_Addons','&#171;','cmd=show&addon='.$addonFolderName).'</div>'.PHP_EOL;
		echo '<table id="themes-table" style="width:100%"><tbody>'.PHP_EOL;
		if (isset($gpLayouts[$config['gpLayout']]['is_addon']))
		{
			$where = 'remote';
			$current = $gpLayouts[$config['gpLayout']]['theme_label'];
		}
		else
		{
			$where = 'local';
			$current = $gpLayouts[$config['gpLayout']]['theme'];
		}
		echo '<tr class="current_theme">';
		echo '<td><font style="font-size:large; font-weight:bold">'.$current.'<br/>- '.$langmessage['current_layout'].'</font></td>';
		echo '<td></td>';
		echo '<td>'.common::Link('Admin_TCChanger','Pick colors','cmd=pick&view=a&where='.$where.'&theme='.rawurlencode($current)).'</td>';
		echo '<td>'.common::Link('Admin_TCChanger',$langmessage['edit'],'cmd=edit&view=a&where='.$where.'&theme='.rawurlencode($current)).'</td>';
		echo '<td>'.common::Link('Admin_TCChanger','Duplicate','cmd=duplicate&where='.$where.'&theme='.rawurlencode($current)).'</td>';
		echo '<td>'.common::Link('Admin_TCChanger',$langmessage['delete'],'cmd=delete&where='.$where.'&theme='.rawurlencode($current)).'</td>';
		echo '</tr>';
		echo '<tr><td colspan="6">&nbsp;</td></tr>';//separator
		if ($all_themes!=array())
		{
			foreach ($all_themes as $key)
			{
				echo '<tr><td colspan="6"><font style="font-size:large; font-weight:bold">'.$key.'</font> (local) template styles:</td></tr>';
				$this->Print_Local_Theme_Colors($key);
				echo '<tr><td colspan="6">&nbsp;</td></tr>';//separator
			}
		}
		if (isset($config['themes']))
		{
			asort($config['themes']);
			foreach ($config['themes'] as $key => $value)
			{
				echo '<tr><td colspan="6"><font style="font-size:large; font-weight:bold">'.$value['name'].'</font> (remote) template uses these styles:</td></tr>';
				$this->Print_Remote_Theme_Colors($key);
				echo '<tr><td colspan="6">&nbsp;</td></tr>';//separator
			}
		}
		echo '</tbody></table>'.PHP_EOL;
		//echo '<div style="clear:both; float:none; visibility: hidden"></div>';
		//echo '<pre>'; print_r($this); echo '</pre>';
	}

	function Print_Local_Theme_Colors($name)
	{
		global $dataDir, $config, $gpLayouts, $langmessage;
		$dir = $dataDir.'/themes/'.$name;
		$subdirs = gpFiles::readDir($dir,1);
		asort($subdirs);
		//print_r($subdirs);
		foreach($subdirs as $subdir){
			if( $subdir == 'images' || $subdir == '.images'){
				continue;
			}
			echo '<tr class="subdir">';
			echo '<td>'.$subdir.'</td>';
			echo '<td>'.common::Link('Admin_Theme_Content',$langmessage['preview'],'cmd=preview&theme='.rawurlencode($name.'(package)/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger','Pick colors','cmd=pick&view=a&where=local&theme='.rawurlencode($name.'/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger',$langmessage['edit'],'cmd=edit&view=a&where=local&theme='.rawurlencode($name.'/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger','Duplicate','cmd=duplicate&where=local&theme='.rawurlencode($name.'/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger',$langmessage['delete'],'cmd=delete&where=local&theme='.rawurlencode($name.'/'.$subdir)).'</td>';
			echo '</tr>';
		}
	}

	function Print_Remote_Theme_Colors($name)
	{
		global $dataDir, $config, $gpLayouts, $langmessage;
		$dir = $dataDir.'/data/_themes/'.$name;
		$subdirs = gpFiles::readDir($dir,1);
		asort($subdirs);
		//print_r($subdirs);
		foreach($subdirs as $subdir){
			if( $subdir == 'images' || $subdir == '.images'){
				continue;
			}
			echo '<tr class="subdir">';
			echo '<td>'.$subdir.'</td>';
			echo '<td>'.common::Link('Admin_Theme_Content',$langmessage['preview'],'cmd=preview&theme='.rawurlencode($config['themes'][$name]['name'].'(remote)/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger','Pick colors','cmd=pick&view=a&where=remote&theme='.rawurlencode($config['themes'][$name]['name'].'/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger',$langmessage['edit'],'cmd=edit&view=a&where=remote&theme='.rawurlencode($config['themes'][$name]['name'].'/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger','Duplicate','cmd=duplicate&where=remote&theme='.rawurlencode($config['themes'][$name]['name'].'/'.$subdir)).'</td>';
			echo '<td>'.common::Link('Admin_TCChanger',$langmessage['delete'],'cmd=delete&where=remote&theme='.rawurlencode($config['themes'][$name]['name'].'/'.$subdir)).'</td>';
			echo '</tr>';
		}
	}

	function Parse($css)
	{
		$a = $css[0];//actual character
		$f = ($a=="\x20" || $a=="\xA0" || $a=="\x0A" || $a=="\x0D" || $a=="\x09" || $a=="\x0B" || $a=="\x00") ? true:false; // indicates the special character or something else
		$j = 0;
		$res = array( 0 => $a );
		for ($i=1; $i<strlen($css); $i++)
		{
			$a = $css[$i];
			if ($a=="\x20" || $a=="\xA0" || $a=="\x0A" || $a=="\x0D" || $a=="\x09" || $a=="\x0B" || $a=="\x00")
			{//echo '1 ';
				if ($f)
				{
					$res[$j] .= $a;
				}
				else
				{
					$j++;
					$res[$j] = $a;
				}
				$f = true;
			}
			else
			{//echo '2 ';
				if ($a==":" || $a==";" || $a=="{" || $a=="}")
				{
					$j++;
					$res[$j] = $a;
					$j++;
					$res[$j] = '';
					$f = true;
				}
				else
				{
					if ($f)
					{
						$j++;
						$res[$j] = $a;
					}
					else
					{
						$res[$j] .= $a;
					}
					$f = false;
				}
			}
		}
		return $res;
	}

	function Show_Permissions($perms)
	{
		//echo substr(sprintf('%o', $perms), -4);
		$info = '<span title="Owner">';
		// Owner
		$info .= (($perms & 0x0100) ? 'r' : '-');
		$info .= (($perms & 0x0080) ? 'w' : '-');
		$info .= (($perms & 0x0040) ?
				(($perms & 0x0800) ? 's' : 'x' ) :
				(($perms & 0x0800) ? 'S' : '-'));
		// Group
		$info .= '</span> &nbsp; <span title="Group">'.(($perms & 0x0020) ? 'r' : '-');
		$info .= (($perms & 0x0010) ? 'w' : '-');
		$info .= (($perms & 0x0008) ?
				(($perms & 0x0400) ? 's' : 'x' ) :
				(($perms & 0x0400) ? 'S' : '-'));
		// World
		$info .= '</span> &nbsp; <span title="Other">'.(($perms & 0x0004) ? 'r' : '-');
		$info .= (($perms & 0x0002) ? 'w' : '-');
		$info .= (($perms & 0x0001) ?
			(($perms & 0x0200) ? 't' : 'x' ) :
			(($perms & 0x0200) ? 'T' : '-'));
		$info .= '</span>';
		return $info;
	}
	
	function clearComments($res)
	{
		$wk = array();
		$com=false;
		foreach ($res as $k => $e)
		{
			$i=0;
			$ee='';
			$len=strlen($e);
			while($i<$len)
			{
				if (($i<$len-1) && $e[$i]=='/' && $e[$i+1]=='*')
					$com=true;
				elseif ($i>0 && $e[$i-1]=='/' && $e[$i]=='*')
					;
				elseif (($i<$len-1) && $e[$i]=='*' && $e[$i+1]=='/')
					$com=false;
				elseif ($i>0 && $e[$i-1]=='*' && $e[$i]=='/')
					;
				elseif (!$com)
					$ee.=$e[$i];
				$i++;
			}
			$wk[$k]=$ee;
		}
		return $wk;
	}
	
	function buildEvent($el,$elp)
	{
		global $gpLayouts,$config;
		//if ($gpLayouts[$config['gpLayout']]['theme']!=$this->style) return ''; //this means to make jquery color changes available only for the current theme
		if (strpos($el,'>')!==false) //nested content selectors... unsupported in this program
			return '';
		$el=preg_replace('/@import(.*);/','',$el);//this solves one possible problem
		//echo $el.'+'.$elp.' / ';
		$el=trim($el); //element that we'll be changing
		$elp=trim($elp); //element's property that we'll be changing
		if ($elp=='')
			return;
		$ret = '';
		$el = explode(',',$el);
		foreach ($el as $ele)
		{
			$elee = explode(' : hover',$ele);
			if (count($elee)==1)//hover not found
			{
				$ret .= '$(\''.trim($ele).'\').css(\'';
				if ($elp=='color') $ret.='color';
				if ($elp=='background' || $elp=='background-color') $ret.='backgroundColor';
				if ($elp=='border') $ret.='borderColor';
				if ($elp=='border-color') $ret.='borderColor';
				if ($elp=='border-left') $ret.='borderLeftColor';
				if ($elp=='border-right') $ret.='borderRightColor';
				if ($elp=='border-top') $ret.='borderTopColor';
				if ($elp=='border-bottom') $ret.='borderBottomColor';
				if ($elp=='text-shadow') $ret.='textShadow';
				$ret .= '\',\'#\'+this.value);';
			}
/*			else //==2 ~ hover... unsupported here
			{
				//$ret.= $elee[0];
				$ret.= ' mycolor = \'#\'+this.value;';
				$ret.= ' $(\''.$elee[0].'\').mouseover(function(){ mycolor1=this.style.color; $(\''.$elee[0].'\').css(\'backgroundColor\',mycolor); mycolor=mycolor1; });  ';
				$ret.= ' $(\''.$elee[0].'\').mouseout(function() { mycolor1=this.style.color; $(\''.$elee[0].'\').css(\'backgroundColor\',mycolor); mycolor=mycolor1; });  ';
			}
*/		}
		return 'onchange="javascript:'.$ret.'"';
		//return 'onchange="javascript:alert(\''.$ret.'  for '.$elp.' property\');"';
	}
	
	function Pick_Colors()
	{
		global $addonRelativeCode,$page,$langmessage,$addonPathCode;
		$page->head .= '<script type="text/javascript" src="'.$addonRelativeCode.'/jscolor/jscolor.js"></script>';
		echo '<div style="float:right">';
		echo 'Access rights: '.$this->Show_Permissions(fileperms($this->styleDir.'/style.css')).' / ';
		echo 'View: ';
		echo ($this->view=='a')? 'A':common::Link('Admin_TCChanger',' A ','cmd=pick&view=a&where='.$this->where.'&theme='.rawurlencode($this->style));
		echo ($this->view=='b')? 'B':common::Link('Admin_TCChanger',' B ','cmd=pick&view=b&where='.$this->where.'&theme='.rawurlencode($this->style));
		echo ($this->view=='c')? 'C':common::Link('Admin_TCChanger',' C ','cmd=pick&view=c&where='.$this->where.'&theme='.rawurlencode($this->style));
		echo ' / '.common::Link('Admin_TCChanger',$langmessage['back']);
		echo '</div>';
		echo '<p style="font-size:large; font-weight:bold">'.$this->style.' style</p>';
		if (file_exists($this->styleDir.'/style.css'))
			$css = file_get_contents($this->styleDir.'/style.css');
		else
		{
			echo 'The theme not exists! '.$this->style;
			return;
		}
		//echo '<pre>'.preg_replace('/#([0-9a-fA-F]{6}|[0-9a-fA-F]{3})[; }]/', '<a>${1}</a>', $css).'</pre>';
		
		$res = $this->Parse($css); //echo '<pre>'; print_r($res); echo '</pre>';
		$wk = $this->clearComments($res); //echo '<pre>'; print_r($wk); echo '</pre>'; return;
		$e_definitions=false;
		$e_el=''; // for what element to build event
		$e_elp=''; // to what property belongs that color
		foreach ($wk as $k => $e)
		{
			if ($e=='{')  //going inside style definitions
				{ $e_definitions=true; $getp=true; }
			elseif ($e=='}')  //going outside style definitions
				{ $e_definitions=false;
					//echo $e_el.'~'.$e_elp.'<br/>';
					$e_el='';
					$e_elp='';
				}
			elseif ($e!='' && $e!=' ' && $e!="\n")
			{
				if (!$e_definitions)
					$e_el.=$e.' ';
				elseif ($getp)
					{ $e_elp=trim($e); if ($e_elp!='') $getp=false; }
				elseif ($e==';')
					$getp=true;
				//echo $e;
			}
			if (strlen($e)==4 && $e[0]=='#') //detecting 3-digit hexa number
			{
				$is_hexa=true;
				for ($i=1; $i<4; $i++)
					if (!(  ($e[$i]>='0' && $e[$i]<='9') || ($e[$i]>='a' && $e[$i]<='f') || ($e[$i]>='A' && $e[$i]<='F') ))
						$is_hexa=false;
				$e= ($is_hexa)? '<input class="color" name="color_'.$k.'" value="'.$e[1].$e[2].$e[3].'" '.$this->buildEvent($e_el,$e_elp).' title="color '.$k.'"/>':$e;
				if ($this->view=='c')
					$wk[$k]=$e;
				else //'a','b'
					$res[$k]=$e;
			}
			elseif (strlen($e)==7 && $e[0]=='#') //detecting 6-digit hexa number
			{
				$is_hexa=true;
				for ($i=1; $i<7; $i++)
					if (!(  ($e[$i]>='0' && $e[$i]<='9') || ($e[$i]>='a' && $e[$i]<='f') || ($e[$i]>='A' && $e[$i]<='F') ))
						$is_hexa=false;
				$e= ($is_hexa)? '<input class="color" name="color_'.$k.'" value="'.$e[1].$e[2].$e[3].$e[4].$e[5].$e[6].'" '.$this->buildEvent($e_el,$e_elp).' title="color '.$k.'"/>':$e;
				if ($this->view=='c')
					$wk[$k]=$e;
				else //'a','b'
					$res[$k]=$e;
			}
			elseif ($e!='') // detecting the color name in array
			{
				$str=ucfirst(strtolower($e));
				$e= (isset($this->colors[$str]))? '<input class="color" name="color_'.$k.'" value="#'.$this->colors[$str].'" '.$this->buildEvent($e_el,$e_elp).' title="color '.$k.'"/>':$e;
				if ($this->view=='c')
					$wk[$k]=$e;
				else //'a','b'
					$res[$k]=$e;
			}
		}
		// finished.
		echo '<form name="tcp" action="'.common::GetUrl('Admin_TCChanger').'" method="post">'.PHP_EOL;
		echo '<div style="height:250px; position:relative; overflow: auto;">'; //for easier navigation
		echo '<pre style="overflow: auto; overflow-Y: hidden;">';
		//print_r($res);
		$p=''; //previous word
		if ($this->view=='a')
		{
			foreach ($res as $v)
			{
				if (($v=='{') && ($p=='' || $p[strlen($p)-1]!="\n"))
					echo "\n";
				if (($p=='{' || $p=='}' || $p==';') && ($v=='' || $v[0]!="\n"))
					echo ($p=='}')? "\n"."\n":"\n";
				if ($v=='color' || $v=='background-color' || $v=='background')
					$v='<strong>'.strtoupper($v).'</strong>';
				echo $v;
				$p=$v;
			}
		}
		elseif ($this->view=='b')
		{
			//default view and formatting
			foreach ($res as $v)
				echo $v;
		}
		elseif ($this->view=='c')
		{
			//default view and formatting
			foreach ($wk as $v)
				echo $v;
		}
		echo '</pre>';
		echo '</div>';
		echo '<div style="float:right; right-margin:3em;">';
		echo '<input type="hidden" name="save_colors" value="Save" />';
		echo '<input type="hidden" name="edited_style" value="'.$this->style.'" />';
		echo '<input type="hidden" name="edited_where" value="'.$this->where.'" />';
		echo '<input type="image" name="floppy" src="'.$addonRelativeCode.'/floppy.png" alt="'.$langmessage['save'].'" title="'.$langmessage['save'].'" />';
		echo '</div>'.PHP_EOL;
		echo '</form>'.PHP_EOL;
		echo '<script type="text/javascript"><!--
			$(document).ready(function(){
				var menus = document.getElementsByClassName(\'menu_top\');
				for(var i=0;i<menus.length;i++)
				{
					var newLI = document.createElement("li");
					newLI.innerHTML=\'<a class="selected">Test menu link \'+i+\'</a>\';
					menus[i].appendChild(newLI);
				}
			});
		--></script>'.PHP_EOL;
	}

	function IsHexa($e)
	{
		$is_hexa=true;
		if (strlen($e)==4 && $e[0]=='#') //detecting 3-digit hexa number
		{
			for ($i=1; $i<4; $i++)
				if (!(  ($e[$i]>='0' && $e[$i]<='9') || ($e[$i]>='a' && $e[$i]<='f') || ($e[$i]>='A' && $e[$i]<='F') ))
					$is_hexa=false;
		}
		elseif (strlen($e)==7 && $e[0]=='#') //detecting 3-digit hexa number
		{
			for ($i=1; $i<7; $i++)
				if (!(  ($e[$i]>='0' && $e[$i]<='9') || ($e[$i]>='a' && $e[$i]<='f') || ($e[$i]>='A' && $e[$i]<='F') ))
					$is_hexa=false;
		}
		else
		{
			$is_hexa=false;
		}
		return $is_hexa;
	}

	function Edit_Style()
	{
		global $addonRelativeCode, $langmessage;
		echo '<div style="float:right">';
		echo 'Access rights: '.$this->Show_Permissions(fileperms($this->styleDir.'/style.css'));
		echo ' / '.common::Link('Admin_TCChanger',$langmessage['back']);
		echo '</div>';
		echo '<p style="font-size:large; font-weight:bold">'.$this->style.'</p>';
		$css = file_get_contents($this->styleDir.'/style.css');
		echo '<form name="tce" action="'.common::GetUrl('Admin_TCChanger').'" method="post">'.PHP_EOL;
		echo '<textarea id="estyle" name="estyle" rows="20" cols="50" wrap="off" style="width:100%; line-height:1.5em; font-family: ProFont, Lucida Console, Courier, Fixedsys">'.htmlspecialchars($css).'</textarea>';
		echo '<div style="float:right; right-margin:3em;">';
		echo '<input type="hidden" name="save_theme_file" value="Save" />';
		echo '<input type="hidden" name="edited_style" value="'.$this->style.'" />';
		echo '<input type="hidden" name="edited_where" value="'.$this->where.'" />';
		echo '<input type="image" name="floppy" src="'.$addonRelativeCode.'/floppy.png" alt="'.$langmessage['save'].'" title="'.$langmessage['save'].'" />';
		echo '</div>'.PHP_EOL;
		echo '</form>'.PHP_EOL;
	}
	
	function Save_Theme_File()
	{
		if (file_put_contents($this->styleDir.'/style.css', $_POST['estyle'], LOCK_EX))
			echo '<p style="font-size:large; font-weight:bold">'.$this->style.' theme saved succesfuly.</p>';
		else
			echo '<p style="font-size:large; font-weight:bold">'.$this->style.' theme save failed.</p>';
	}

	function Process_Form()
	{
		global $addonPathData,$addonPathCode, $config, $langmessage;
		//echo '<pre>'; print_r($config); echo '</pre>';
		// the following algorithm must be similar to the one in Pick_Colors() function
		if (file_exists($this->styleDir.'/style.css'))
			$css = file_get_contents($this->styleDir.'/style.css');
		else
		{
			echo 'The theme not exists! '.$this->style;
			return;
		}
		$res = $this->Parse($css); //print_r($res);
		echo '<span style="float:right;">'.common::Link('Admin_TCChanger',$langmessage['Refresh']).'</span>';
		foreach ($res as $k => $e)
		{
			if (!isset($_POST['color_'.$k]) || !$this->IsHexa('#'.$_POST['color_'.$k]))
				continue;
			//echo $k.': '.$res[$k].' &gt; '.$_POST['color_'.$k].'<br/>';
			if ($this->IsHexa($e))
			{
				if (isset($_POST['color_'.$k]) && $this->IsHexa('#'.$_POST['color_'.$k]))
					$res[$k]='#'.$_POST['color_'.$k];
			}
			elseif ($e!='') // detecting the color name in array
			{
				$str=ucfirst(strtolower($e));
				if (isset($this->colors[$str]) && ($this->colors[$str]!=$_POST['color_'.$k]))
					$res[$k]='#'.$_POST['color_'.$k];
			}
		}
		// finished.
		//echo '<pre style="overflow: auto; overflow-Y: hidden;">'.$result.'</pre>';return;
		$css='';
		foreach ($res as $value)
			$css .= $value;
		echo '<font style="font-size:large; font-weight:bold">'.$this->style.'</font> ';
		if (file_put_contents($this->styleDir.'/style.css', $css, LOCK_EX))
			echo 'Theme saved succesfully!';
		else
			echo 'Theme couldn\'t not saved. Please check file permissions for the file '.$this->styleDir.'/style.css';
	}

	function Duplicate_Theme()
	{
		global $addonRelativeCode,$page, $dataDir, $langmessage;
		if (!file_exists($this->styleDir.'/style.css'))
			return;
		$split = explode('/',$this->style,2);
		echo '<p style="font-size:large; font-weight:bold"> Duplicate theme '.$split[0].' / '.$split[1].'</p>';
		if (isset($_POST['duplicate']) && isset($_POST['new_style']) && $_POST['new_style']!='')
		{
			if (!file_exists($this->targetDir))
				if (mkdir($this->targetDir))
					echo '<br/>The directory was created: '.$_POST['new_style'];
				else
					echo '<br/>Failed creating the directory: '.$_POST['new_style'];
			$this->Recursive_Copy($this->styleDir,$this->targetDir);
			echo '<br/>Duplication has finished for '.$split[0].' / '.$_POST['new_style'].'<br/><br/>';
		}
		else
		{
			echo '<form name="duplicate-theme" action="'.common::GetUrl('Admin_TCChanger').'" method="post">'.PHP_EOL;
			echo 'Please enter a new theme name: <b>'.$split[0].' / </b> <input type="text" name="new_style" value="" />';
			echo '<div style="float:right; right-margin:3em;">';
			echo '<input type="hidden" name="duplicate" value="duplicate" />';
			echo '<input type="hidden" name="edited_style" value="'.$this->style.'" />';
			echo '<input type="hidden" name="edited_where" value="'.$this->where.'" />';
			echo '<input type="image" name="floppy" src="'.$addonRelativeCode.'/floppy.png" alt="'.$langmessage['save'].'" title="'.$langmessage['save'].'" />';
			echo '</div>'.PHP_EOL;
			echo '</form>'.PHP_EOL;
		}
	}

	function Delete_Theme()
	{
		global $gpLayouts,$addonRelativeCode, $langmessage;
		$split = explode('/',$this->style,2);
		echo '<p style="font-size:large; font-weight:bold"> Delete the theme: '.$split[0].' / '.$split[1].'</p>';
		if (!file_exists($this->styleDir))
		{
			echo '<p>This theme not exists! '.$this->style.'</p>';
			return;
		}
		$used='';
		if ($this->where=='local')
		{
			$cmp=$this->style;
		}
		else
		{
			$parts=explode('/',$this->styleDir);
			$cmp=$parts[count($parts)-2].'/'.$parts[count($parts)-1];
		}
		//echo $cmp;
		foreach ($gpLayouts as $key => $value)
			if ($value['theme']==$cmp)
				$used.=$value['label'].' ';
		if ($used!='')
		{
			echo '<p>This theme can not be deleted, because the following layouts use it: ';
			echo common::Link('Admin_Theme_Content',$used);
			return;
		}
		parse_str($_SERVER['QUERY_STRING']);
		if (!isset($confirmed) || ($confirmed!='yes'))
		{
			echo $langmessage['delete_confirm'].' - ';
			echo common::Link('Admin_TCChanger',$langmessage['remove'],'cmd=delete&where='.$this->where.'&theme='.rawurlencode($this->style).'&confirmed=yes');
			return;
		}
		$this->Recursive_Delete($this->styleDir);
		if (rmdir($this->styleDir))
			echo '<br/>The theme was deleted '.$this->style;
		else
			echo '<br/>The theme could not be deleted. '.$this->style;
	}

	function Recursive_Delete($path)
	{
		if ($handle = opendir ($path))
		{
			while (false !== ($file = readdir($handle)))
			{
				$nextpath = $path . '/' . $file;
				if ($file != '.' && $file != '..' && !is_link ($nextpath))
				{
					if (is_dir ($nextpath))
					{
						$this->Recursive_Delete($nextpath);
						if (rmdir($nextpath)) /*delete directory*/
							echo '<br/>The directory was deleted '.$nextpath;
						else
							echo '<br/>Unable to delete the directory '.$nextpath;
					}
					elseif (is_file ($nextpath))
					{
						if (unlink($nextpath)) /*delete file*/
							echo '<br/>The file was deleted '.$nextpath;
						else
							echo '<br/>Unable to delete the file '.$nextpath;
					}
				}
			}
		}
		closedir ($handle);
	}

	function Recursive_Copy($path,$targetDir)
	{
		if ($handle = opendir ($path))
		{
			while (false !== ($file = readdir($handle)))
			{
				$nextpath = $path . '/' . $file;
				$nexttarget = $targetDir . '/' . $file;
				if ($file != '.' && $file != '..' && !is_link ($nextpath))
				{
					if (is_dir ($nextpath))
					{
						if (!file_exists($nexttarget))
							if (mkdir($nexttarget)) /*make directory*/
								echo '<br/>The directory was created '.$nexttarget;
							else
								echo '<br/>Failed to create the directory '.$nexttarget;
						$this->Recursive_Copy($nextpath,$nexttarget);
					}
					elseif (is_file ($nextpath))
					{
						if (copy($nextpath, $nexttarget)) /*copy file*/
							echo '<br/>The file was copied '.$nexttarget;
						else
							echo '<br/>Unable to copy the file '.$nexttarget;
					}
				}
			}
		}
		closedir ($handle);
	}

	function Run()
	{
		if (isset($_POST['save_colors']))
			$this->Process_Form();
		if (isset($_POST['save_theme_file']))
			$this->Save_Theme_File();
		if ($this->cmd=='' || isset($_POST['save_colors']))
			$this->Show_Themes_List();
		elseif ($this->cmd=='pick')
			$this->Pick_Colors();
		elseif ($this->cmd=='edit')
			$this->Edit_Style();
		elseif ($this->cmd=='delete')
		{
			$this->Delete_Theme();
			$this->Show_Themes_List();
		}
		elseif ($this->cmd=='duplicate')
		{
			$this->Duplicate_Theme();
			$this->Show_Themes_List();
		}
		//print_r($_POST);
		//print_r($this);
	}
}

/* main program */
$c=new Theme_Colors_Changer;
$c->Run();
unset($c);
